/************************************************************************
* (c) Copyright Freescale Semiconductor, Inc 2010, All Rights Reserved  *
*************************************************************************

************************************************************************
*                                                                      *
*        Standard Software Flash Driver For FTFL           		         *
*                                                                      *
* FILE NAME     :  FlashInit.c                                         *
* DATE          :  June 11,2010                                        *
*                                                                      *
* AUTHOR        :  FPT Team                                            *
* E-mail        :  b28216@freescale.com                                *
*                                                                      *
************************************************************************/

/************************** CHANGES ***********************************
0.0.1    	06.09.2010    	FPT Team            		Initial Version
0.1.0    	06.11.2010    	FPT Team            		Finalize to 0.1.0 
***********************************************************************/

/* include the header files */
#include "SSD_Types.h"
#include "SSD_FTFL.h"
#include "SSD_FTFL_Internal.h"

/*********************************************************************
*
*  Function Name    : FlashInit
*  Description      : Initialize the Flash memory.
*  Arguments        : PFLASH_SSD_CONFIG
*  Return Value     : UINT32
*
**********************************************************************/

UINT32 FlashInit (PFLASH_SSD_CONFIG PSSDConfig)
{
	UINT8  EEEDataSetSize;	/* store EEE Data Set Size */
	UINT8  DEPartitionCode;	/* store D/E-Flash Partition Code */
  UINT32 returnCode;      /* return code variable */

    /* set the default return code as FTFL_OK */
    returnCode = FTFL_OK;
	
#if(DEBLOCK_SIZE != 0)	

#ifdef BYTE_ADDRESSING
	// byte address
	
	/* check CCIF bit of the flash status register */
    while(FALSE == (REG_BIT_TEST(PSSDConfig->ftflRegBase + FTFL_FSTAT_OFFSET, FTFL_FSTAT_CCIF)))
    {
        /* wait till CCIF bit is set */
    }
	
    /* clear RDCOLERR & ACCERR & FPVIOL flag in flash status register */
    REG_WRITE(PSSDConfig->ftflRegBase + FTFL_FSTAT_OFFSET, \
			      	(FTFL_FSTAT_RDCOLERR | FTFL_FSTAT_ACCERR | FTFL_FSTAT_FPVIOL));
	
	/* Write Command Code to FCCOB0 */
	REG_WRITE(PSSDConfig->ftflRegBase + FTFL_FCCOB0_OFFSET, FTFL_READ_RESOURCE);
	/* Write address to FCCOB1/2/3 */
	REG_WRITE(PSSDConfig->ftflRegBase + FTFL_FCCOB1_OFFSET, ((UINT8)(DFLASH_IFR_LONGWORD_ADDRESS >> 16)));
	REG_WRITE(PSSDConfig->ftflRegBase + FTFL_FCCOB2_OFFSET, ((UINT8)((DFLASH_IFR_LONGWORD_ADDRESS >> 8) & 0xFF)));
	REG_WRITE(PSSDConfig->ftflRegBase + FTFL_FCCOB3_OFFSET, ((UINT8)(DFLASH_IFR_LONGWORD_ADDRESS & 0xFF)));
	
	/* clear CCIF bit */
    REG_WRITE(PSSDConfig->ftflRegBase + FTFL_FSTAT_OFFSET, FTFL_FSTAT_CCIF);
	
	/* check CCIF bit */
    while(FALSE == (REG_BIT_TEST(PSSDConfig->ftflRegBase + FTFL_FSTAT_OFFSET, FTFL_FSTAT_CCIF)))
    {
		/* wait till CCIF bit is set */
    }
	
	#if 1	
		// RM
		/* Read returned value of FCCOB6/7 to the variables */
		EEEDataSetSize = REG_READ(PSSDConfig->ftflRegBase + FTFL_FCCOB6_OFFSET);
		DEPartitionCode = REG_READ(PSSDConfig->ftflRegBase + FTFL_FCCOB7_OFFSET);
	#else
		// BG
		/* Read returned value of FCCOB6/7 to the variables */
		EEEDataSetSize = REG_READ(PSSDConfig->ftflRegBase + FTFL_FCCOB5_OFFSET);
		DEPartitionCode = REG_READ(PSSDConfig->ftflRegBase + FTFL_FCCOB4_OFFSET);
	#endif	
	
#else
	//word  address
	/* check CCIF bit of the flash status register */
    while(FALSE == (REG_BIT_TEST16(PSSDConfig->ftflRegBase + FTFL_FSTAT_OFFSET, FTFL_FSTAT_CCIF)))
    {
        /* wait till CCIF bit is set */
    }
	
    /* clear RDCOLERR & ACCERR & FPVIOL flag in flash status register */
    REG_WRITE16(PSSDConfig->ftflRegBase + FTFL_FSTAT_OFFSET, \
			      	(FTFL_FSTAT_RDCOLERR | FTFL_FSTAT_ACCERR | FTFL_FSTAT_FPVIOL));
	
	/* Write Command Code to FCCOB0 */
	REG_WRITE16(PSSDConfig->ftflRegBase + FTFL_FCCOB0_OFFSET, FTFL_READ_RESOURCE);
	/* Write address to FCCOB1/2/3 */
	REG_WRITE16(PSSDConfig->ftflRegBase + FTFL_FCCOB1_OFFSET, ((UINT8)(DFLASH_IFR_LONGWORD_ADDRESS >> 16)));
	REG_WRITE16(PSSDConfig->ftflRegBase + FTFL_FCCOB2_OFFSET, ((UINT8)((DFLASH_IFR_LONGWORD_ADDRESS >> 8) & 0xFF)));
	REG_WRITE16(PSSDConfig->ftflRegBase + FTFL_FCCOB3_OFFSET, ((UINT8)(DFLASH_IFR_LONGWORD_ADDRESS & 0xFF)));
	
	/* clear CCIF bit */
    REG_WRITE16(PSSDConfig->ftflRegBase + FTFL_FSTAT_OFFSET, FTFL_FSTAT_CCIF);
	
	/* check CCIF bit */
    while(FALSE == (REG_BIT_TEST16(PSSDConfig->ftflRegBase + FTFL_FSTAT_OFFSET, FTFL_FSTAT_CCIF)))
    {
		/* wait till CCIF bit is set */
    }
	#if 1	
		// RM
		/* Read returned value of FCCOB6/7 to the variables */
		EEEDataSetSize = REG_READ16(PSSDConfig->ftflRegBase + FTFL_FCCOB6_OFFSET);
		DEPartitionCode = REG_READ16(PSSDConfig->ftflRegBase + FTFL_FCCOB7_OFFSET);
	#else
		// BG
		/* Read returned value of FCCOB6/7 to the variables */
		EEEDataSetSize = REG_READ16(PSSDConfig->ftflRegBase + FTFL_FCCOB5_OFFSET);
		DEPartitionCode = REG_READ16(PSSDConfig->ftflRegBase + FTFL_FCCOB4_OFFSET);
	#endif	
#endif	
	/* Calculate D-Flash size and EEE size */
	switch (DEPartitionCode & 0x0F)
	{
		case 0: PSSDConfig->DFlashBlockSize = DEPART_0000; break;
		case 1: PSSDConfig->DFlashBlockSize = DEPART_0001; break;
		case 2: PSSDConfig->DFlashBlockSize = DEPART_0010; break;
		case 3: PSSDConfig->DFlashBlockSize = DEPART_0011; break;
		case 4: PSSDConfig->DFlashBlockSize = DEPART_0100; break;
		case 5: PSSDConfig->DFlashBlockSize = DEPART_0101; break;
		case 6: PSSDConfig->DFlashBlockSize = DEPART_0110; break;
		case 7: PSSDConfig->DFlashBlockSize = DEPART_0111; break;
		case 8: PSSDConfig->DFlashBlockSize = DEPART_1000; break;
		case 9: PSSDConfig->DFlashBlockSize = DEPART_1001; break;
		case 10: PSSDConfig->DFlashBlockSize = DEPART_1010; break;
		case 11: PSSDConfig->DFlashBlockSize = DEPART_1011; break;
		case 12: PSSDConfig->DFlashBlockSize = DEPART_1100; break;
		case 13: PSSDConfig->DFlashBlockSize = DEPART_1101; break;
		case 14: PSSDConfig->DFlashBlockSize = DEPART_1110; break;
		case 15: PSSDConfig->DFlashBlockSize = DEPART_1111; break;
		default: break;
	}
		
	switch (EEEDataSetSize & 0x0F)
	{
		case 0: PSSDConfig->EEEBlockSize = EEESIZE_0000; break;
		case 1: PSSDConfig->EEEBlockSize = EEESIZE_0001; break;
		case 2: PSSDConfig->EEEBlockSize = EEESIZE_0010; break;
		case 3: PSSDConfig->EEEBlockSize = EEESIZE_0011; break;
		case 4: PSSDConfig->EEEBlockSize = EEESIZE_0100; break;
		case 5: PSSDConfig->EEEBlockSize = EEESIZE_0101; break;
		case 6: PSSDConfig->EEEBlockSize = EEESIZE_0110; break;
		case 7: PSSDConfig->EEEBlockSize = EEESIZE_0111; break;
		case 8: PSSDConfig->EEEBlockSize = EEESIZE_1000; break;
		case 9: PSSDConfig->EEEBlockSize = EEESIZE_1001; break;
		case 10: PSSDConfig->EEEBlockSize = EEESIZE_1010; break;
		case 11: PSSDConfig->EEEBlockSize = EEESIZE_1011; break;
		case 12: PSSDConfig->EEEBlockSize = EEESIZE_1100; break;
		case 13: PSSDConfig->EEEBlockSize = EEESIZE_1101; break;
		case 14: PSSDConfig->EEEBlockSize = EEESIZE_1110; break;
		case 15: PSSDConfig->EEEBlockSize = EEESIZE_1111; break;
		default: break;
	}
		
#else
	/* If size of D/E-Flash = 0 */
	PSSDConfig->DFlashBlockSize = 0;
	PSSDConfig->EEEBlockSize = 0;
#endif

    /* Enter Debug state if enabled */
    if (TRUE == (PSSDConfig->DebugEnable))
    {
         asm
         (
          debughlt           /* enter Debug state */
         );
    }

    return(returnCode);
}
/* end of file */